disp('Pick data directory for processing')
disp('')
CWD=pwd;
Data_Dir=uigetdir;
%cd(Data_Dir)
datafiles=uipickfiles('filterspec',[Data_Dir,'/*profile.mat']);
cd(CWD)
numfiles=length(datafiles);
for j=1:numfiles
  %FILENAME=fullfile(Data_Dir,datafiles(j));
  load(char(datafiles(j)),'prof');
  Vh(j,:)=prof.Vh';
  theta(j,:)=prof.theta';
  w(j,:)=prof.w';
  snr(j,:)=prof.avgsnr;
  beta(j,:)=prof.beta;
  timestamp(j,1)=prof.start_time;
  ind=find(prof.turb>5);
  Vh(j,ind)=NaN;
  theta(j,ind)=NaN;
  w(j,ind)=NaN;
  snr(j,ind)=NaN;
  beta(j,ind)=NaN;
  heights=prof.heights;
end

hs=panel_day(timestamp,Vh,theta,w,heights)